/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.generator.CraftLimitedRegion;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator
implements BiomeManager.NoiseBiomeSource {
    private static final Logger f_211627_;
    public static final Codec<ChunkGenerator> f_62136_;
    public final Registry<StructureSet> f_207955_;
    protected final BiomeSource f_62137_;
    protected final BiomeSource f_62138_;
    public final Optional<HolderSet<StructureSet>> f_207956_;
    private final Map<ConfiguredStructureFeature<?, ?>, List<StructurePlacement>> f_207957_ = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkPos>>> f_204350_ = new Object2ObjectArrayMap();
    private boolean f_207958_;
    @Deprecated
    public final long f_212255_;
    public SpigotWorldConfig conf;

    protected static final <T extends ChunkGenerator> Products.P1<RecordCodecBuilder.Mu<T>, Registry<StructureSet>> m_208005_(RecordCodecBuilder.Instance<T> p_208006_) {
        return p_208006_.group((App)RegistryOps.m_206832_(Registry.f_211073_).forGetter(p_208008_ -> p_208008_.f_207955_));
    }

    public ChunkGenerator(Registry<StructureSet> p_207960_, Optional<HolderSet<StructureSet>> p_207961_, BiomeSource p_207962_) {
        this(p_207960_, p_207961_, p_207962_, p_207962_, 0L);
    }

    public ChunkGenerator(Registry<StructureSet> p_207964_, Optional<HolderSet<StructureSet>> p_207965_, BiomeSource p_207966_, BiomeSource p_207967_, long p_207968_) {
        this.f_207955_ = p_207964_;
        this.f_62137_ = p_207966_;
        this.f_62138_ = p_207967_;
        this.f_207956_ = p_207965_;
        this.f_212255_ = p_207968_;
    }

    public Stream<Holder<StructureSet>> m_207969_() {
        return this.f_207956_.isPresent() ? this.f_207956_.get().m_203614_() : this.f_207955_.m_203611_().map(Holder::m_205706_);
    }

    private Stream<StructureSet> possibleStructureSetsSpigot() {
        return this.m_207969_().map(Holder::m_203334_).map(structureset -> {
            StructurePlacement patt4623$temp = structureset.f_210004_();
            if (patt4623$temp instanceof RandomSpreadStructurePlacement) {
                RandomSpreadStructurePlacement randomConfig = (RandomSpreadStructurePlacement)patt4623$temp;
                if (this.conf != null) {
                    String name = this.f_207955_.m_7981_((StructureSet)structureset).m_135815_();
                    int seed = randomConfig.f_204976_();
                    switch (name) {
                        case "desert_pyramids": {
                            seed = this.conf.desertSeed;
                            break;
                        }
                        case "end_cities": {
                            seed = this.conf.endCitySeed;
                            break;
                        }
                        case "nether_complexes": {
                            seed = this.conf.netherSeed;
                            break;
                        }
                        case "igloos": {
                            seed = this.conf.iglooSeed;
                            break;
                        }
                        case "jungle_temples": {
                            seed = this.conf.jungleSeed;
                            break;
                        }
                        case "woodland_mansions": {
                            seed = this.conf.mansionSeed;
                            break;
                        }
                        case "ocean_monuments": {
                            seed = this.conf.monumentSeed;
                            break;
                        }
                        case "nether_fossils": {
                            seed = this.conf.fossilSeed;
                            break;
                        }
                        case "ocean_ruins": {
                            seed = this.conf.oceanSeed;
                            break;
                        }
                        case "pillager_outposts": {
                            seed = this.conf.outpostSeed;
                            break;
                        }
                        case "ruined_portals": {
                            seed = this.conf.portalSeed;
                            break;
                        }
                        case "shipwrecks": {
                            seed = this.conf.shipwreckSeed;
                            break;
                        }
                        case "swamp_huts": {
                            seed = this.conf.swampSeed;
                            break;
                        }
                        case "villages": {
                            seed = this.conf.villageSeed;
                        }
                    }
                    structureset = new StructureSet(structureset.f_210003_(), (StructurePlacement)new RandomSpreadStructurePlacement(randomConfig.f_204973_(), randomConfig.f_204974_(), randomConfig.f_204975_(), seed, randomConfig.f_204977_()));
                }
            }
            return structureset;
        });
    }

    private void m_208097_() {
        Set set = this.f_62138_.m_207840_();
        this.possibleStructureSetsSpigot().forEach(p_208094_ -> {
            StructureSet structureset = p_208094_;
            for (StructureSet.StructureSelectionEntry structureset$structureselectionentry : structureset.f_210003_()) {
                this.f_207957_.computeIfAbsent((ConfiguredStructureFeature)structureset$structureselectionentry.f_210026_().m_203334_(), p_208087_ -> new ArrayList()).add(structureset.f_210004_());
            }
            StructurePlacement structureplacement = structureset.f_210004_();
            if (structureplacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                if (structureset.f_210003_().stream().anyMatch(p_208071_ -> p_208071_.m_210035_(set::contains))) {
                    this.f_204350_.put(concentricringsstructureplacement, this.generateRingPositions((StructureSet)p_208094_, concentricringsstructureplacement));
                }
            }
        });
    }

    private CompletableFuture<List<ChunkPos>> generateRingPositions(StructureSet p_211668_, ConcentricRingsStructurePlacement p_211669_) {
        return p_211669_.f_204952_() == 0 ? CompletableFuture.completedFuture(List.of()) : CompletableFuture.supplyAsync(Util.m_183946_("placement calculation", () -> {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
            ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
            Set set = p_211668_.f_210003_().stream().flatMap(p_208015_ -> ((ConfiguredStructureFeature)p_208015_.f_210026_().m_203334_()).m_209752_().m_203614_()).collect(Collectors.toSet());
            int i = p_211669_.f_204950_();
            int j = p_211669_.f_204952_();
            int k = p_211669_.f_204951_();
            Random random = new Random();
            random.setSeed(this.f_212255_);
            double d0 = random.nextDouble() * Math.PI * 2.0;
            int l = 0;
            int i1 = 0;
            for (int j1 = 0; j1 < j; ++j1) {
                double d1 = (double)(4 * i + i * i1 * 6) + (random.nextDouble() - 0.5) * (double)i * 2.5;
                int k1 = (int)Math.round(Math.cos(d0) * d1);
                int l1 = (int)Math.round(Math.sin(d0) * d1);
                Pair pair = this.f_62137_.m_207829_(SectionPos.m_175554_((int)k1, (int)8), 0, SectionPos.m_175554_((int)l1, (int)8), 112, set::contains, random, this.m_183403_());
                if (pair != null) {
                    BlockPos blockpos = (BlockPos)pair.getFirst();
                    k1 = SectionPos.m_123171_((int)blockpos.m_123341_());
                    l1 = SectionPos.m_123171_((int)blockpos.m_123343_());
                }
                list.add(new ChunkPos(k1, l1));
                d0 += Math.PI * 2 / (double)k;
                if (++l != k) continue;
                l = 0;
                k += 2 * k / (++i1 + 1);
                k = Math.min(k, j - j1);
                d0 += random.nextDouble() * Math.PI * 2.0;
            }
            double d2 = (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            f_211627_.debug("Calculation for {} took {}s", (Object)p_211668_, (Object)d2);
            return list;
        }), Util.m_183991_());
    }

    protected abstract Codec<? extends ChunkGenerator> m_6909_();

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> m_187743_() {
        return Registry.f_122890_.m_7854_(this.m_6909_());
    }

    public abstract ChunkGenerator m_6819_(long var1);

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> p_196743_, Executor p_196744_, Blender p_196745_, StructureFeatureManager p_196746_, ChunkAccess p_196747_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            p_196747_.m_183442_((arg_0, arg_1, arg_2, arg_3) -> ((BiomeSource)this.f_62138_).m_203407_(arg_0, arg_1, arg_2, arg_3), this.m_183403_());
            return p_196747_;
        }), Util.m_183991_());
    }

    public abstract Climate.Sampler m_183403_();

    public Holder<Biome> m_203495_(int p_204416_, int p_204417_, int p_204418_) {
        return this.m_62218_().m_203407_(p_204416_, p_204417_, p_204418_, this.m_183403_());
    }

    public abstract void m_183516_(WorldGenRegion var1, long var2, BiomeManager var4, StructureFeatureManager var5, ChunkAccess var6, GenerationStep.Carving var7);

    @Nullable
    public Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> m_207970_(ServerLevel p_207971_, HolderSet<ConfiguredStructureFeature<?, ?>> p_207972_, BlockPos p_207973_, int p_207974_, boolean p_207975_) {
        Set set = p_207972_.m_203614_().flatMap(p_211699_ -> ((ConfiguredStructureFeature)p_211699_.m_203334_()).m_209752_().m_203614_()).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return null;
        }
        Set set1 = this.f_62138_.m_207840_();
        if (Collections.disjoint(set1, set)) {
            return null;
        }
        Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> pair = null;
        double d0 = Double.MAX_VALUE;
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Object holder : p_207972_) {
            if (set1.stream().noneMatch(arg_0 -> ((HolderSet)((ConfiguredStructureFeature)holder.m_203334_()).m_209752_()).m_203333_(arg_0))) continue;
            for (StructurePlacement structureplacement : this.m_208090_((Holder<ConfiguredStructureFeature<?, ?>>)holder)) {
                map.computeIfAbsent(structureplacement, p_211663_ -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement1 = (StructurePlacement)entry.getKey();
            if (structureplacement1 instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement1;
                BlockPos blockpos = this.m_204382_(p_207973_, concentricringsstructureplacement);
                double d1 = p_207973_.m_123331_((Vec3i)blockpos);
                if (!(d1 < d0)) continue;
                d0 = d1;
                pair = Pair.of((Object)blockpos, (Object)((Holder)((Set)entry.getValue()).iterator().next()));
                continue;
            }
            if (!(structureplacement1 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int i = SectionPos.m_123171_((int)p_207973_.m_123341_());
            int j = SectionPos.m_123171_((int)p_207973_.m_123343_());
            for (int k = 0; k <= p_207974_; ++k) {
                boolean flag = false;
                for (Map.Entry entry1 : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry1.getKey();
                    Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> pair1 = ChunkGenerator.m_208059_((Set)entry1.getValue(), (LevelReader)((Object)p_207971_), p_207971_.m_8595_(), i, j, k, p_207975_, p_207971_.m_7328_(), randomspreadstructureplacement);
                    if (pair1 == null) continue;
                    flag = true;
                    double d2 = p_207973_.m_123331_((Vec3i)pair1.getFirst());
                    if (!(d2 < d0)) continue;
                    d0 = d2;
                    pair = pair1;
                }
                if (!flag) continue;
                return pair;
            }
        }
        return pair;
    }

    @Nullable
    private BlockPos m_204382_(BlockPos p_204383_, ConcentricRingsStructurePlacement p_204384_) {
        List<ChunkPos> list = this.m_204380_(p_204384_);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        BlockPos blockpos = null;
        double d0 = Double.MAX_VALUE;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (ChunkPos chunkpos : list) {
            blockpos$mutableblockpos.m_122178_(SectionPos.m_175554_((int)chunkpos.f_45578_, (int)8), 32, SectionPos.m_175554_((int)chunkpos.f_45579_, (int)8));
            double d1 = blockpos$mutableblockpos.m_123331_((Vec3i)p_204383_);
            if (blockpos == null) {
                blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
            d0 = d1;
        }
        return blockpos;
    }

    @Nullable
    private static Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> m_208059_(Set<Holder<ConfiguredStructureFeature<?, ?>>> p_208060_, LevelReader p_208061_, StructureFeatureManager p_208062_, int p_208063_, int p_208064_, int p_208065_, boolean p_208066_, long p_208067_, RandomSpreadStructurePlacement p_208068_) {
        int i = p_208068_.f_204973_();
        for (int j = -p_208065_; j <= p_208065_; ++j) {
            boolean flag = j == -p_208065_ || j == p_208065_;
            for (int k = -p_208065_; k <= p_208065_; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -p_208065_ || k == p_208065_;
                if (!flag && !flag1) continue;
                int l = p_208063_ + i * j;
                int i1 = p_208064_ + i * k;
                ChunkPos chunkpos = p_208068_.m_204991_(p_208067_, l, i1);
                for (Holder<ConfiguredStructureFeature<?, ?>> holder : p_208060_) {
                    StructureCheckResult structurecheckresult = p_208062_.m_207777_(chunkpos, holder.m_203334_(), p_208066_);
                    if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!p_208066_ && structurecheckresult == StructureCheckResult.START_PRESENT) {
                        return Pair.of((Object)StructureFeature.m_204766_(p_208068_, chunkpos), holder);
                    }
                    ChunkAccess chunkaccess = p_208061_.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_);
                    StructureStart structurestart = p_208062_.m_207802_(SectionPos.m_175562_((ChunkAccess)chunkaccess), holder.m_203334_(), (FeatureAccess)chunkaccess);
                    if (structurestart == null || !structurestart.m_73603_()) continue;
                    if (p_208066_ && structurestart.m_73606_()) {
                        p_208062_.m_196674_(structurestart);
                        return Pair.of((Object)StructureFeature.m_204766_(p_208068_, structurestart.m_163625_()), holder);
                    }
                    if (p_208066_) continue;
                    return Pair.of((Object)StructureFeature.m_204766_(p_208068_, structurestart.m_163625_()), holder);
                }
            }
        }
        return null;
    }

    public void applyBiomeDecoration(WorldGenLevel generatoraccessseed, ChunkAccess ichunkaccess, StructureFeatureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.m_183372_(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.m_7697_());
            int x = ichunkaccess.m_7697_().f_45578_;
            int z = ichunkaccess.m_7697_().f_45579_;
            for (BlockPopulator populator : world.getPopulators()) {
                WorldgenRandom seededrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(generatoraccessseed.m_7328_()));
                seededrandom.m_64690_(generatoraccessseed.m_7328_(), x, z);
                populator.populate((WorldInfo)world, (Random)seededrandom, x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    public void m_183372_(WorldGenLevel p_187712_, ChunkAccess p_187713_, StructureFeatureManager p_187714_) {
        ChunkPos chunkpos = p_187713_.m_7697_();
        if (!SharedConstants.m_183707_(chunkpos)) {
            SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)chunkpos, (int)p_187712_.m_151560_());
            BlockPos blockpos = sectionpos.m_123249_();
            Registry<ConfiguredStructureFeature<?, ?>> registry = p_187712_.m_5962_().m_175515_(Registry.f_122882_);
            Map<Integer, List<ConfiguredStructureFeature>> map = registry.m_123024_().collect(Collectors.groupingBy(p_211653_ -> p_211653_.f_65403_.m_67095_().ordinal()));
            List list = this.f_62137_.m_186733_();
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));
            long i = worldgenrandom.m_64690_(p_187712_.m_7328_(), blockpos.m_123341_(), blockpos.m_123343_());
            ObjectArraySet set = new ObjectArraySet();
            if (this instanceof FlatLevelSource) {
                this.f_62137_.m_207840_().stream().map(Holder::m_203334_).forEach(((Set)set)::add);
            } else {
                ChunkPos.m_45596_((ChunkPos)sectionpos.m_123251_(), (int)1).forEach(arg_0 -> ChunkGenerator.lambda$applyBiomeDecoration$12(p_187712_, (Set)set, arg_0));
                set.retainAll(this.f_62137_.m_207840_().stream().map(Holder::m_203334_).collect(Collectors.toSet()));
            }
            int j = list.size();
            try {
                Registry<PlacedFeature> registry1 = p_187712_.m_5962_().m_175515_(Registry.f_194567_);
                int i1 = Math.max(GenerationStep.Decoration.values().length, j);
                for (int k = 0; k < i1; ++k) {
                    int l = 0;
                    if (p_187714_.m_47271_()) {
                        for (ConfiguredStructureFeature configuredstructurefeature : map.getOrDefault(k, Collections.emptyList())) {
                            worldgenrandom.m_190064_(i, l, k);
                            Supplier<String> supplier = () -> registry.m_7854_(configuredstructurefeature).map(Object::toString).orElseGet(configuredstructurefeature::toString);
                            try {
                                p_187712_.m_183406_(supplier);
                                p_187714_.m_207794_(sectionpos, configuredstructurefeature).forEach(p_211647_ -> p_211647_.m_7129_(p_187712_, p_187714_, this, (Random)worldgenrandom, ChunkGenerator.m_187717_(p_187713_), chunkpos));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport1 = CrashReport.m_127521_(exception, "Feature placement");
                                crashreport1.m_127514_("Feature").m_128165_("Description", (CrashReportDetail<String>)((CrashReportDetail)supplier::get));
                                throw new ReportedException(crashreport1);
                            }
                            ++l;
                        }
                    }
                    if (k >= j) continue;
                    IntArraySet intset = new IntArraySet();
                    for (Biome biome : set) {
                        List<HolderSet<PlacedFeature>> list1 = biome.m_47536_().m_47818_();
                        if (k >= list1.size()) continue;
                        HolderSet<PlacedFeature> holderset = list1.get(k);
                        BiomeSource.StepFeatureData biomesource$stepfeaturedata1 = (BiomeSource.StepFeatureData)list.get(k);
                        holderset.m_203614_().map(Holder::m_203334_).forEach(arg_0 -> ChunkGenerator.lambda$applyBiomeDecoration$15((IntSet)intset, biomesource$stepfeaturedata1, arg_0));
                    }
                    int j1 = intset.size();
                    int[] aint = intset.toIntArray();
                    Arrays.sort(aint);
                    BiomeSource.StepFeatureData biomesource$stepfeaturedata = (BiomeSource.StepFeatureData)list.get(k);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature = (PlacedFeature)biomesource$stepfeaturedata.f_196677_().get(l1);
                        Supplier<String> supplier1 = () -> registry1.m_7854_(placedfeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedfeature).toString());
                        worldgenrandom.m_190064_(i, l1, k);
                        try {
                            p_187712_.m_183406_(supplier1);
                            placedfeature.m_191806_(p_187712_, this, (Random)worldgenrandom, blockpos);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport2 = CrashReport.m_127521_(exception1, "Feature placement");
                            crashreport2.m_127514_("Feature").m_128165_("Description", (CrashReportDetail<String>)((CrashReportDetail)supplier1::get));
                            throw new ReportedException(crashreport2);
                        }
                    }
                }
                p_187712_.m_183406_(null);
            }
            catch (Exception exception2) {
                CrashReport crashreport = CrashReport.m_127521_(exception2, "Biome decoration");
                crashreport.m_127514_("Generation").m_128159_("CenterX", chunkpos.f_45578_).m_128159_("CenterZ", chunkpos.f_45579_).m_128159_("Seed", i);
                throw new ReportedException(crashreport);
            }
        }
    }

    public boolean m_212265_(ResourceKey<StructureSet> p_212266_, long p_212267_, int p_212268_, int p_212269_, int p_212270_) {
        StructureSet structureset = this.f_207955_.m_6246_(p_212266_);
        if (structureset == null) {
            return false;
        }
        StructurePlacement structureplacement = structureset.f_210004_();
        for (int i = p_212268_ - p_212270_; i <= p_212268_ + p_212270_; ++i) {
            for (int j = p_212269_ - p_212270_; j <= p_212269_ + p_212270_; ++j) {
                if (!structureplacement.m_212129_(this, p_212267_, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private static BoundingBox m_187717_(ChunkAccess p_187718_) {
        ChunkPos chunkpos = p_187718_.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        LevelHeightAccessor levelheightaccessor = p_187718_.m_183618_();
        int k = levelheightaccessor.m_141937_() + 1;
        int l = levelheightaccessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public abstract void m_183621_(WorldGenRegion var1, StructureFeatureManager var2, ChunkAccess var3);

    public abstract void m_6929_(WorldGenRegion var1);

    public int m_142051_(LevelHeightAccessor p_156157_) {
        return 64;
    }

    public BiomeSource m_62218_() {
        return this.f_62138_;
    }

    public abstract int m_6331_();

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_203315_(Holder<Biome> p_204386_, StructureFeatureManager p_204387_, MobCategory p_204388_, BlockPos p_204389_) {
        Map map = p_204387_.m_207815_(p_204389_);
        for (Map.Entry entry : map.entrySet()) {
            ConfiguredStructureFeature configuredstructurefeature = (ConfiguredStructureFeature)entry.getKey();
            StructureSpawnOverride structurespawnoverride = (StructureSpawnOverride)configuredstructurefeature.f_209744_.get((Object)p_204388_);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.f_210043_() == StructureSpawnOverride.BoundingBoxType.PIECE ? p_211631_ -> p_204387_.m_207788_(p_204389_, p_211631_) : p_211666_ -> p_211666_.m_73601_().m_71051_((Vec3i)p_204389_);
            p_204387_.m_207781_(configuredstructurefeature, (LongSet)entry.getValue(), p_211692_ -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)p_211692_)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.f_210044_();
        }
        return p_204386_.m_203334_().m_47518_().m_151798_(p_204388_);
    }

    public static Stream<ConfiguredStructureFeature<?, ?>> m_208044_(Registry<ConfiguredStructureFeature<?, ?>> p_208045_, StructureFeature<?> p_208046_) {
        return p_208045_.m_123024_().filter(p_211656_ -> p_211656_.f_65403_ == p_208046_);
    }

    public void m_62199_(RegistryAccess p_62200_, StructureFeatureManager p_62201_, ChunkAccess p_62202_, StructureManager p_62203_, long p_62204_) {
        ChunkPos chunkpos = p_62202_.m_7697_();
        SectionPos sectionpos = SectionPos.m_175562_((ChunkAccess)p_62202_);
        this.possibleStructureSetsSpigot().forEach(p_212264_ -> {
            StructurePlacement structureplacement = p_212264_.f_210004_();
            List list = p_212264_.f_210003_();
            for (StructureSet.StructureSelectionEntry structureset$structureselectionentry : list) {
                StructureStart structurestart = p_62201_.m_207802_(sectionpos, (ConfiguredStructureFeature)structureset$structureselectionentry.f_210026_().m_203334_(), (FeatureAccess)p_62202_);
                if (structurestart == null || !structurestart.m_73603_()) continue;
                return;
            }
            if (structureplacement.m_212129_(this, p_62204_, chunkpos.f_45578_, chunkpos.f_45579_)) {
                if (list.size() == 1) {
                    this.m_208016_((StructureSet.StructureSelectionEntry)list.get(0), p_62201_, p_62200_, p_62203_, p_62204_, p_62202_, chunkpos, sectionpos);
                } else {
                    ArrayList arraylist = new ArrayList(list.size());
                    arraylist.addAll(list);
                    WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                    worldgenrandom.m_190068_(p_62204_, chunkpos.f_45578_, chunkpos.f_45579_);
                    int i = 0;
                    for (StructureSet.StructureSelectionEntry structureset$structureselectionentry1 : arraylist) {
                        i += structureset$structureselectionentry1.f_210027_();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.StructureSelectionEntry structureset$structureselectionentry2;
                        int j = worldgenrandom.nextInt(i);
                        int k = 0;
                        Iterator iterator = arraylist.iterator();
                        while (iterator.hasNext() && (j -= (structureset$structureselectionentry2 = (StructureSet.StructureSelectionEntry)iterator.next()).f_210027_()) >= 0) {
                            ++k;
                        }
                        StructureSet.StructureSelectionEntry structureset$structureselectionentry3 = (StructureSet.StructureSelectionEntry)arraylist.get(k);
                        if (this.m_208016_(structureset$structureselectionentry3, p_62201_, p_62200_, p_62203_, p_62204_, p_62202_, chunkpos, sectionpos)) {
                            return;
                        }
                        arraylist.remove(k);
                        i -= structureset$structureselectionentry3.f_210027_();
                    }
                }
            }
        });
    }

    private boolean m_208016_(StructureSet.StructureSelectionEntry p_208017_, StructureFeatureManager p_208018_, RegistryAccess p_208019_, StructureManager p_208020_, long p_208021_, ChunkAccess p_208022_, ChunkPos p_208023_, SectionPos p_208024_) {
        HolderSet holderset;
        Predicate<Holder> predicate;
        int i;
        ConfiguredStructureFeature configuredstructurefeature = (ConfiguredStructureFeature)p_208017_.f_210026_().m_203334_();
        StructureStart structurestart = configuredstructurefeature.m_204707_(p_208019_, this, this.f_62137_, p_208020_, p_208021_, p_208023_, i = ChunkGenerator.m_207976_(p_208018_, p_208022_, p_208024_, configuredstructurefeature), (LevelHeightAccessor)p_208022_, predicate = arg_0 -> this.lambda$tryGenerateStructure$22(holderset = configuredstructurefeature.m_209752_(), arg_0));
        if (structurestart.m_73603_()) {
            p_208018_.m_207806_(p_208024_, configuredstructurefeature, structurestart, (FeatureAccess)p_208022_);
            return true;
        }
        return false;
    }

    private static int m_207976_(StructureFeatureManager p_207977_, ChunkAccess p_207978_, SectionPos p_207979_, ConfiguredStructureFeature<?, ?> p_207980_) {
        StructureStart structurestart = p_207977_.m_207802_(p_207979_, p_207980_, (FeatureAccess)p_207978_);
        return structurestart != null ? structurestart.m_73608_() : 0;
    }

    protected Holder<Biome> m_203427_(Holder<Biome> p_204385_) {
        return p_204385_;
    }

    public void m_62177_(WorldGenLevel p_62178_, StructureFeatureManager p_62179_, ChunkAccess p_62180_) {
        int i = 8;
        ChunkPos chunkpos = p_62180_.m_7697_();
        int j = chunkpos.f_45578_;
        int k = chunkpos.f_45579_;
        int l = chunkpos.m_45604_();
        int i1 = chunkpos.m_45605_();
        SectionPos sectionpos = SectionPos.m_175562_((ChunkAccess)p_62180_);
        for (int j1 = j - 8; j1 <= j + 8; ++j1) {
            for (int k1 = k - 8; k1 <= k + 8; ++k1) {
                long l1 = ChunkPos.m_45589_((int)j1, (int)k1);
                for (StructureStart structurestart : p_62178_.m_6325_(j1, k1).m_6633_().values()) {
                    try {
                        if (!structurestart.m_73603_() || !structurestart.m_73601_().m_71019_(l, i1, l + 15, i1 + 15)) continue;
                        p_62179_.m_207797_(sectionpos, structurestart.m_210081_(), l1, (FeatureAccess)p_62180_);
                        DebugPackets.m_133711_((WorldGenLevel)p_62178_, (StructureStart)structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.m_127521_(exception, "Generating structure reference");
                        CrashReportCategory crashreportcategory = crashreport.m_127514_("Structure");
                        Optional<Registry<ConfiguredStructureFeature<?, ?>>> optional = p_62178_.m_5962_().m_6632_(Registry.f_122882_);
                        crashreportcategory.m_128165_("Id", (CrashReportDetail<String>)((CrashReportDetail)() -> optional.map(p_211661_ -> p_211661_.m_7981_(structurestart.m_210081_()).toString()).orElse("UNKNOWN")));
                        crashreportcategory.m_128165_("Name", (CrashReportDetail<String>)((CrashReportDetail)() -> Registry.f_122841_.m_7981_(p_211658_.m_210081_().f_65403_).toString()));
                        crashreportcategory.m_128165_("Class", (CrashReportDetail<String>)((CrashReportDetail)() -> structurestart.m_210081_().getClass().getCanonicalName()));
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> m_183489_(Executor var1, Blender var2, StructureFeatureManager var3, ChunkAccess var4);

    public abstract int m_6337_();

    public abstract int m_142062_();

    public abstract int m_142647_(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4);

    public abstract NoiseColumn m_141914_(int var1, int var2, LevelHeightAccessor var3);

    public int m_156174_(int p_156175_, int p_156176_, Heightmap.Types p_156177_, LevelHeightAccessor p_156178_) {
        return this.m_142647_(p_156175_, p_156176_, p_156177_, p_156178_);
    }

    public int m_156179_(int p_156180_, int p_156181_, Heightmap.Types p_156182_, LevelHeightAccessor p_156183_) {
        return this.m_142647_(p_156180_, p_156181_, p_156182_, p_156183_) - 1;
    }

    public void m_211700_() {
        if (!this.f_207958_) {
            this.m_208097_();
            this.f_207958_ = true;
        }
    }

    @Nullable
    public List<ChunkPos> m_204380_(ConcentricRingsStructurePlacement p_204381_) {
        this.m_211700_();
        CompletableFuture<List<ChunkPos>> completablefuture = this.f_204350_.get(p_204381_);
        return completablefuture != null ? completablefuture.join() : null;
    }

    private List<StructurePlacement> m_208090_(Holder<ConfiguredStructureFeature<?, ?>> p_208091_) {
        this.m_211700_();
        return this.f_207957_.getOrDefault(p_208091_.m_203334_(), List.of());
    }

    public abstract void m_207076_(List<String> var1, BlockPos var2);

    private /* synthetic */ boolean lambda$tryGenerateStructure$22(HolderSet holderset, Holder p_211672_) {
        return holderset.m_203333_(this.m_203427_(p_211672_));
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$15(IntSet intset, BiomeSource.StepFeatureData biomesource$stepfeaturedata1, PlacedFeature p_211682_) {
        intset.add(biomesource$stepfeaturedata1.f_196678_().applyAsInt(p_211682_));
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$12(WorldGenLevel p_187712_, Set set, ChunkPos p_211651_) {
        ChunkAccess chunkaccess = p_187712_.m_6325_(p_211651_.f_45578_, p_211651_.f_45579_);
        for (LevelChunkSection levelchunksection : chunkaccess.m_7103_()) {
            levelchunksection.m_188013_().m_196879_(p_211688_ -> set.add((Biome)((Object)((Object)p_211688_.m_203334_()))));
        }
    }

    static {
        Registry.m_122961_(Registry.f_122890_, "noise", NoiseBasedChunkGenerator.f_64314_);
        Registry.m_122961_(Registry.f_122890_, "flat", FlatLevelSource.f_64164_);
        Registry.m_122961_(Registry.f_122890_, "debug", DebugLevelSource.f_64111_);
        f_211627_ = LogUtils.getLogger();
        f_62136_ = Registry.f_122890_.m_194605_().dispatchStable(ChunkGenerator::m_6909_, Function.identity());
    }
}

